# Geometric Progression

A sequence of numbers is said to be in a `Geometric progression` if the ratio of any two consecutive terms is always the same. In simple terms, it means that the next number in the series is calculated by multiplying a fixed number to the previous number in the series.

For example, 2, 4, 8, 16 is a GP because ratio of any two consecutive terms in the series (common ratio) is the same (4 / 2 = 8 / 4 = 16 / 8 = 2).
<p align="center">
    <img width="60%" src="https://user-images.githubusercontent.com/75872316/122635376-2fad6f80-d101-11eb-9d06-74c5c854cc9d.png">
</p>

**Facts about Geometric Progression:**

1. **Initial term:** In a geometric progression, the first number is called the initial term.
2. **Common ratio:** The ratio of any two consecutive terms by taking the previous term in the denominator.
3. The behaviour of a geometric sequence depends on the value of the common ratio. If the common ratio is:

- Positive, the terms will all be of the same sign as the initial term.
- Negative, the terms will alternate between positive and negative.
- Greater than 1, there will be exponential growth towards positive or negative infinity (depending on the sign of the initial term).
- 1, the progression is a constant sequence.
- Between -1 and 1 but not zero, there will be exponential decay towards zero.
- -1, the progression is an alternating sequence.
- Less than -1, for the absolute values there is exponential growth towards (unsigned) infinity, due to the alternating sign.

**Formula of the nth term of a G.P:**

`a` is the initial term, and `d` is a common difference. Thus, the explicit formula is:
<p align="center">
    <img width="60%" src="https://user-images.githubusercontent.com/75872316/122635586-6fc12200-d102-11eb-9a87-333c9a578cc8.png">
</p>

**Formula of the sum of the first nth term of G.P:**

<p align="center">
    <img width="60%" src="https://user-images.githubusercontent.com/75872316/122635613-9717ef00-d102-11eb-89db-5182e966b1db.png">
</p>

**General Formulas to solve problems related to Geometric Progressions:**

If `a` is the first term and `r` is the common ratio:
nth term of a GP = `a*rn-1`.

- Geometric Mean = `nth root of the product of n terms in the GP`.
- Sum of `n` terms of a GP (r < 1) = `[a (1 – rn)] / [1 – r]`.
- Sum of `n` terms of a GP (r > 1) = `[a (rn – 1)] / [r – 1]`.
- Sum of infinite terms of a GP (r < 1) = `(a) / (1 – r)`.

# Source

- [Geometric Progression](https://www.geeksforgeeks.org/geometric-progression/)

# YouTube

- [Video URL for concept](https://youtu.be/gua96ju_FBk)
- [Video for understanding GP Dynamic Programming in C++](https://youtu.be/92ZldzuGUHs)
